<?php
///////////////////////////////////////////////////
//// MAILCHIMP IMPLEMENTATION THROUGH HOOKS ///////
///////////////////////////////////////////////////


class pcma_mailchimp_integr {
    private $mc_instance; // pcma_mailchimp class instance
    
    
    // constructor - defining pcma_mailchimp class instance and setting up hooks
    public function __construct() {
        include_once(PCMA_DIR .'/classes/pcma_mailchimp.php');
        $this->mc_instance = new pcma_mailchimp();
        
        if(!$this->mc_instance->is_ready()) {
            return false;
        } 
        
        
        add_filter('pc_form_fields_filter', array($this, 'register_disclaimer_field')); // inject newsletter disclaimer field into pvtcontent engine 
        add_filter('pc_user_dashboard_main_tab_sections', array($this, 'user_dashboard_discl'), 21, 2); // admin user dashboard - add switch to set it as subscribed
        add_action('pc_user_added', array($this, 'def_discl_val'), 15); // subscription management if registration field is not used 
        add_filter('pc_users_list_badges', array($this, 'users_list_badge'), 40, 2); // mailchimp subscription badge in users list
        add_action('pc_user_staus_changed', array($this, 'status_change'), 10, 2); // status change detection - remove or add
        
        
        // auto-sync hooks
        if(get_option('pcma_mc_auto_sync')) {
            $hook_target = array($this, 'single_subscr_manag');
            
            add_action('pc_user_added', $hook_target, 200); // after subscription management hook
            add_action('pc_user_updated', $hook_target, 200);
            add_action('pc_bulk_cat_assign_done', $hook_target);
            add_action('pcpp_expired_subscription', $hook_target); 
            
        	add_action('pc_imported_users', array($this, 'bulk_add')); // bulk user addition
            add_action('pc_pre_user_delete', array($this, 'bulk_del')); // single/bulk user removal     
        }
        
        // categories sync on addition/update/deletion	
        $hook_target = array($this, 'on_cats_change');
        add_action('created_pg_user_categories', $hook_target);
        add_action('edited_pg_user_categories', $hook_target);
        add_action('delete_pg_user_categories', $hook_target);
        
        // handle mailchimp webhook to unsubscribe
        add_action('init', array($this, 'unsubscribe_webhook')); 
    }
    
    
    
    
    
    /*
     * Inject newsletter disclaimer field into pvtcontent engine 
     */
    public function register_disclaimer_field($fields) {
		$fields['pcma_mc_disclaimer'] = array(
			'label' 	=> __("Mailchimp disclaimer", PCMA_ML),
			'type' 		=> 'single_checkbox',
			'subtype' 	=> '',
			'maxlen' 	=> 1,
			'opt'		=> '1',
			'check_txt'	=> strip_tags((string)get_option('pcma_mc_discl_txt', __('I want to receive periodical newsletters', PCMA_ML)), '<br><a><strong><em>'),
			'disclaimer'=> true,
			'note' 		=> __("Mailchimp disclaimer", PCMA_ML),
		);
		
		return $fields;
	}
    
    
    
    /*
     * admin user dashboard - add switch to set it as subscribed
     */
    public function user_dashboard_discl($sections, $user_id) {
		if(!pcma_is_active() || !$user_id || !pc_wpuc_static::current_wp_user_can_edit_pc_user($user_id)) {
			return $sections;	
		}
		// check mandatory data
		global $pc_users;
		$user_data = $pc_users->get_user($user_id, array(
			'to_get' => array('email', 'status')
		));
		
		if(!$user_data['email'] || (int)$user_data['status'] != 1) {
			return $sections;	
		}
        
		return 
		$sections + array(
			'pcma_mc' => array(
				'name'		=> 'Mail Actions add-on - Mailchimp '. __('Sync', PCMA_ML),
				'classes'	=> 'pc_ud_onehalf_w lor',
				'callback' 	=> 'pcma_mailchimp_integr::user_dashboard_discl_cb'
			)
		);	
	}
    
    
    
    /* 
     * user dashboard switch - $this->user_dashboard_discl() callback outputting HTML 
     */
    public static function user_dashboard_discl_cb($user_id) {
		global $pc_meta;
		$user_agrees = $pc_meta->get_meta($user_id, 'pcma_mc_disclaimer'); // get agreement via meta manag - $user_data is ok for form fields
		
		if($user_agrees) {
			echo '
			<div class="pc_warn pc_wps_warn pc_success">
				'.__("User agreed to be synced in Mailchimp", PCMA_ML).
				'<button type="button" class="button-secondary" id="pcma_mc_unsub">'. __("Revoke Agreement", PCMA_ML) .'</button>';
            
            if(!get_option('pcma_mc_auto_sync')) {
                echo '<button type="button" class="button-secondary" id="pcma_mc_resync">'. __("Re-sync data", PCMA_ML) .'</button>';
            }
            
            echo '
			</div>';
		}
		else {
			echo '
			<div class="pc_warn pc_wps_warn pc_warning">
				'.__("User didn't agree to be synced in Mailchimp", PCMA_ML) .
				'<button type="button" class="button-secondary" id="pcma_mc_sub">'. __("Force Agreement", PCMA_ML) .'</button>
			</div>';	
		}
		
		
		// javascript to subscribe and un-subscribe
		?>
		<script type="text/javascript">
        (function($) { 
            "use strict";  

            const nonce = '<?php echo wp_create_nonce('lcwp_nonce') ?>'; 
            let pcma_mc_is_acting = false;

            
            // ajax call's function
            const pcma_mc_discl = function(action) {

                const $btn = $('#pcma_mc_unsub, #pcma_mc_sub');
                $btn.fadeTo(200, 0.7);
                pcma_mc_is_acting = true;

                var data = {
                    action: 'pcma_mc_add_user_discl_cmd',
                    uid: <?php echo $user_id ?>,
                    cmd: action,
                    nonce: nonce,
                };
                $.post(ajaxurl, data, function(response) {
                    if($.trim(response) == 'success') {
                        lc_wp_popup_message('success', "<?php esc_attr_e("Operation successfully performed!", PCMA_ML) ?>");

                        setTimeout(function() {
                            location.reload(); 
                        }, 1800);
                    }
                    else {
                        lc_wp_popup_message('error', response);
                    }
                })
                .fail(function(e) {
                    if(e.status) {
                        console.error(e);
                        lc_wp_popup_message('error', "<?php esc_attr_e("Error performing the operation", PCMA_ML) ?>");
                    }
                })
                .always(function() {
                    $btn.fadeTo(200, 1);
                    pcma_mc_is_acting = false;
                });
            };


            
            // unsubscribe
            $(document).on('click', '#pcma_mc_unsub', function(e) {
                if(pcma_mc_is_acting) {
                    return false;
                }
                e.preventDefault();

                if(confirm("<?php esc_attr_e("User will not be synced anymore. Cotinue?") ?>")) {	
                    pcma_mc_discl('unsub');
                }
            });

            // subscribe
            $(document).on('click', '#pcma_mc_sub', function(e) {
                if(pcma_mc_is_acting) {
                    return false;
                }
                e.preventDefault();

                if(confirm("<?php esc_attr_e("You might override user will. Cotinue?") ?>")) {	
                    pcma_mc_discl('sub');
                }
            });
            
            
            
            // re-sync manually
            $(document).on('click', '#pcma_mc_resync', function(e) {
                if(pcma_mc_is_acting) {
                    return false;    
                }
                const $btn = $(this);
                
                $btn.fadeTo(200, 0.7);
                pcma_mc_is_acting = true;

                var data = {
                    action: 'pcma_mc_manual_resync',
                    uid: <?php echo $user_id ?>,
                    nonce: nonce,
                };
                $.post(ajaxurl, data, function(response) {
                    if($.trim(response) == 'success') {
                        lc_wp_popup_message('success', "<?php esc_attr_e("Operation successfully performed!", PCMA_ML) ?>");
                    }
                    else {
                        lc_wp_popup_message('error', response);
                    }
                })
                .fail(function(e) {
                    if(e.status) {
                        console.error(e);
                        lc_wp_popup_message('error', "<?php esc_attr_e("Error performing the operation", PCMA_ML) ?>");
                    }
                })
                .always(function() {
                    $btn.fadeTo(200, 1);
                    pcma_mc_is_acting = false;
                });
            });
        })(jQuery);
		</script>
		<?php
	}
    
    
    
    
    /*
     * Subscription management if registration field is not used 
     */
    public function def_discl_val($user_id) {
		global $pc_meta;
		if($pc_meta->has_meta($user_id, 'pcma_mc_disclaimer') !== false) {
            return false;
        }
		
		$val = (get_option('pcma_mc_def_discl')) ? 1 : '';
		$pc_meta->add_meta($user_id, 'pcma_mc_disclaimer', $val);
	}
    
    
    
    /*
     * Mailchimp subscription badge in users list
     */
    public function users_list_badge($badges, $user_id) {
		global $pc_meta;
		
		if($pc_meta->get_meta($user_id, 'pcma_mc_disclaimer')) {
			$badges .= '<img src="'.PCMA_URL.'/img/mc_badge.png" title="'. esc_attr__('allow mailchimp subscription', PCMA_ML) .'" />';
		}
		
		return $badges;
	}
    
    
    
    
    /*
     * single user addition / update
     */
	public function single_subscr_manag($subj) {
		if(isset($GLOBALS['pcma_mc_already_changed'])) {
			return false;	
		}

		// multiple users - just update
		if(is_array($subj)) {
			$this->mc_instance->subscribe_members($subj);			
		}
		
		// single user - check whether to subscribe or not
		else {
            global $pc_meta;
            $mc_discl = $pc_meta->get_meta($subj, 'pcma_mc_disclaimer');
            
			// PCMA-FILTER - allow remote control over single user sync with mailchimp - return true to sync or false to unsync - passes user ID
			$to_subscribe_or_not = (bool)apply_filters('pcma_mailchimp_user_subscribe', $mc_discl, (int)$subj); 
            
			($to_subscribe_or_not) ? 
                $this->mc_instance->subscribe_members((array)$subj) : 
                $this->mc_instance->remove_members((array)$subj);	
		}
	}
    
    
    
    
    /*
     * Bulk user addition
     */
	public function bulk_add() {
		$this->mc_instance->subscribe_members();		
	}
    
    
    
    
    /*
     * Single/bulk user removal
     */
	public function bulk_del($subj) {
		$this->mc_instance->remove_members($subj);		
	}
    
    
    
    
    /* 
     * status change detection - remove or add
     */
	public function status_change($subj, $new_status) {
		$GLOBALS['pcma_mc_already_changed'] = true; // flag to avoid doubled operations
		
		if($new_status == 2 || $new_status == 3) {
			$this->mc_instance->remove_members($subj);
		}
		elseif($new_status == 1 && get_option('pcma_mc_auto_sync')) {
			$this->mc_instance->subscribe_members((array)$subj);		
		}
	}
	
    
    
    
    /*
     * categories sync on addition/update/deletion	
     */
    public function on_cats_change() {
        $this->mc_instance->sync_cats();        
    }
    
    
    
    
    /* 
     * Handle mailchimp webhook to unsubscribe
     */
    public function unsubscribe_webhook() {
        if(!isset($_GET['pcma_mc_unsubscribe']) || !isset($_REQUEST['type'])) {
            return false;   
        }
        #error_log("Error message1 - ".json_encode($_REQUEST), 3, PCMA_DIR."/log.txt"); // DEBUG
        
        if($_REQUEST['type'] != 'unsubscribe' || !isset($_REQUEST['data'])) {
            return false;
        }
        global $pc_users, $pc_meta;
        
        $data = (array)$_REQUEST['data'];
        
        $user = $pc_users->get_users(array(
            'limit' => 1,
            'to_get' => array('id'),
            'search' => array(
                array('key'=>'email', 'operator'=>'=', 'val'=>$data['email'])
            )
        ));

        if(count($user)) {
            $pc_meta->update_meta($user[0]['id'], 'pcma_mc_disclaimer', '');	

            // PCMA-ACTION - allow extra operation when user unsubscribes from mailing list
            do_action('pcma_mailchimp_unsubscribed', $user[0]['id']);
        }
    }
    
    
}



// init class
add_action('pvtcont_init', function() {
    new pcma_mailchimp_integr();  
}, 2);